/*
 * Decompiled with CFR 0.152.
 */
package org.antarcticgardens.cna.content.motor.extension;

import com.simibubi.create.content.kinetics.motor.CreativeMotorBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import org.antarcticgardens.cna.content.motor.extension.MotorExtensionScrollValueBehaviour;
import org.antarcticgardens.cna.content.motor.extension.variants.IMotorExtensionVariant;

public class MotorExtensionBlockEntity
extends SmartBlockEntity {
    private MotorExtensionScrollValueBehaviour stressBehavior;
    private float multiplier = 1.0f;
    private final IMotorExtensionVariant variant;

    public MotorExtensionBlockEntity(class_2591<?> arg, class_2338 arg2, class_2680 arg3, IMotorExtensionVariant variant) {
        super(arg, arg2, arg3);
        this.variant = variant;
    }

    public static BlockEntityBuilder.BlockEntityFactory<MotorExtensionBlockEntity> create(IMotorExtensionVariant variant) {
        return (type, pos, state) -> new MotorExtensionBlockEntity(type, pos, state, variant);
    }

    public void tick() {
        super.tick();
        if (this.multiplier > this.variant.getMultiplier()) {
            this.multiplier = this.variant.getMultiplier();
            this.stressBehavior.setValue((int)(this.multiplier * 100.0f));
        }
        this.stressBehavior.step = this.variant.getScrollStep();
        this.stressBehavior.betweenValidated(1, (int)(100.0f * this.variant.getMultiplier()));
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.stressBehavior = new MotorExtensionScrollValueBehaviour((class_2561)CreateLang.translateDirect((String)"scroll.create_new_age.motor.stress_multiplier", (Object[])new Object[0]), this, (ValueBoxTransform)new MotorValueBox(), 1);
        this.stressBehavior.value = 100;
        this.stressBehavior.withCallback(i -> {
            this.multiplier = (float)i.intValue() / 100.0f;
            this.stressBehavior.value = i;
            this.notifyUpdate();
        });
        behaviours.add((BlockEntityBehaviour)this.stressBehavior);
    }

    public float getMultiplier() {
        return this.multiplier;
    }

    public IMotorExtensionVariant getVariant() {
        return this.variant;
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        this.multiplier = compound.method_10583("stressMultiplier");
        this.stressBehavior.value = (int)this.multiplier * 100;
        super.read(compound, clientPacket);
    }

    protected void write(class_2487 compound, boolean clientPacket) {
        compound.method_10548("stressMultiplier", this.multiplier);
        super.write(compound, clientPacket);
    }

    static class MotorValueBox
    extends ValueBoxTransform.Sided {
        MotorValueBox() {
        }

        protected class_243 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)13.5);
        }

        public class_243 getLocalOffset(class_1936 level, class_2338 pos, class_2680 state) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            return super.getLocalOffset(level, pos, state).method_1019(class_243.method_24954((class_2382)facing.method_10163()).method_1021(-0.0625)).method_1019(new class_243(facing.method_23955()).method_1021(0.125));
        }

        public void rotate(class_1936 level, class_2338 pos, class_2680 state, class_4587 ms) {
            super.rotate(level, pos, state, ms);
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() == class_2350.class_2351.field_11052) {
                return;
            }
            if (this.getSide() != class_2350.field_11036) {
                return;
            }
            TransformStack.of((class_4587)ms).rotateZDegrees(-AngleHelper.horizontalAngle((class_2350)facing) + 180.0f);
        }

        protected boolean isSideActive(class_2680 state, class_2350 direction) {
            class_2350 facing = (class_2350)state.method_11654((class_2769)CreativeMotorBlock.FACING);
            if (facing.method_10166() != class_2350.class_2351.field_11052 && direction == class_2350.field_11033) {
                return false;
            }
            return direction.method_10166() != facing.method_10166();
        }
    }
}

